
Cisco Secure Network Access is a suite of services embedded in Cisco Catalyst switches and Wireless LAN Controllers (WLCs). It leverages the Cisco Identity Services Engine (ISE) to provide secure access to network resources.

---

### Key Features

#### Authentication

- **Strong Authentication Methods**:
    - 802.1X
    - MAC Authentication Bypass (**MAB**)
    - Web Authentication
- **Broad Client Support**:
    - 802.1X supplicants for various operating systems
    - Open-source supplicants for Linux clients

#### Authorization

- **Policy-Based Authorization**:
    - Downloadable Access Control Lists (ACLs)
    - VLAN Assignment
    - Security Group Tags (SGTs)

---

### Deployment Details

#### Wired and Wireless Networks

- **802.1X Protocol**:
    - Applied at physical switch ports on wired networks
    - Applied on Wireless LANs (WLANs) via Cisco WLCs
- **Fallback Authentication Options**:
    - MAB
    - Web Authentication (for devices like printers, IP cameras, or guest users)

#### Client Requirements

- **802.1X Supplicant**:
    - Required for both wired and wireless clients
    - Can be a Cisco supplicant, native OS supplicant, or open-source supplicant

#### Use Cases

- **Wireless Users**:
    - Ideal candidates for initial deployments due to the expectation of authentication before network access
- **Non-Supplicant Devices**:
    - Devices without 802.1X support can use MAB or web authentication

---

### Deployment Architecture

#### Network Components

- **Access Layer**:
    - 802.1X authentication deployed on access switches and WLCs
    - WLCs enforce authentication on wireless access points
- **Fallback Options**:
    - MAB and web authentication enabled at the access layer

#### Data Center

- **Cisco ISE**:
    - Provides authentication services to access switches and WLCs
    - Deployed inside data centers